

/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLTOUCH
#define WAYLANDBACKEND_WLTOUCH 1

#include <wayland-client.h>

namespace WaylandBackend
{

class WLTouch
{
public:
    WLTouch(struct wl_seat *wlSeat, struct wl_event_queue *eventQ);
    virtual ~WLTouch();
    
    void clearIfFocusMatches(struct wl_surface *wlSurface);
    
private:
    struct wl_touch   *_wlTouch;
    struct wl_seat    *_wlSeat;
    struct wl_surface *_touchFocus;

    static const struct wl_touch_listener _touchListener;
    static void touchHandleDown(void* data, struct wl_touch* touch,
                                uint32_t serial, uint32_t time,
                                struct wl_surface* surface, int32_t id,
                                wl_fixed_t xw, wl_fixed_t yw);

    static void touchHandleMotion(void* data, struct wl_touch* touch,
                                  uint32_t time, int32_t id, wl_fixed_t xw,
                                  wl_fixed_t yw);

    static void touchHandleFrame(void* data, struct wl_touch* touch);

    static void touchHandleCancel(void* data, struct wl_touch* touch);

    static void touchHandleUp(void* data, struct wl_touch* touch,
                              uint32_t serial, uint32_t time, int32_t id);
};

}

#endif
